<?php

use Codexpert\CoDesigner\Helper;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Text_Stroke;

// Exit if accessed directly

if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

$widget = $args['this'];
$placeholders   = [ '%%user_name%%', '%%website_link%%', '%%admin_name%%'];


$widget->start_controls_section(
    'order_reset_heading',
    [
        'label'      => __( 'Heading', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_email_type' => 'customer-reset-password',
        ],
    ]
);

$widget->add_control(
    'reset_heading_important_note',
    [
        'label' => __( 'Important Note', 'codesigner-pro' ),
        'type' 	=> Controls_Manager::RAW_HTML,
        'raw' 	=> sprintf( __( 'You can use the placeholders. %s. This will replace with actual order data.', 'codesigner-pro' ), "<code>" . implode( '</code> <code>' ,$placeholders ) . "</code>" ),
        'content_classes' => 'elementor-panel-alert elementor-panel-alert-success',
    ]
);

$widget->add_control(
    'order_heading_txt_reset',
    [
        'label'         => __( 'Heading Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Password Reset Request', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->end_controls_section();

$widget->start_controls_section(
    'order_reset_body',
    [
        'label'      => __( 'Body', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_email_type' => 'customer-reset-password',
        ],
    ]
);

$widget->add_control(
    'reset_body_important_note',
    [
        'label' => __( 'Important Note', 'codesigner-pro' ),
        'type' 	=> Controls_Manager::RAW_HTML,
        'raw' 	=> sprintf( __( 'You can use the placeholders. %s. This will replace with actual order data.', 'codesigner-pro' ), "<code>" . implode( '</code> <code>' ,$placeholders ) . "</code>" ),
        'content_classes' => 'elementor-panel-alert elementor-panel-alert-success',
    ]
);

$widget->add_control(
    'order_sub_txt_reset',
    [
        'label'         => __( 'Sub Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXTAREA,
        'rows'          => 5, 
        'default'       => __( 'Hi %%user_name%% , I am %%admin_name%% Someone has requested a new password for the following account on %%website_link%%' , 'codesigner-pro' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);
$widget->add_control(
    'user_section_user_head_msg_text',
    [
        'label'         => __( 'Notice Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( "If you didn’t make this request, just ignore this email. If you’d like to proceed.", 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);
$widget->add_control(
    'link_text_reset',
    [
        'label'         => __( 'Link Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( "Click here to reset your password", 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);
$widget->add_control(
    'thanks_txt_reset',
    [
        'label'         => __( 'Thanks Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Thanks for reading', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->end_controls_section();

$widget->start_controls_section(
    'new_order_reset',
    [
        'label'      => __( 'Background', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'customer-reset-password',
        ],
    ]
);
$widget->add_control(
    'new_order_bg_section_color_reset',
    [
        'label' 	=> esc_html__( 'Section Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-reset-password .cd-no-border' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'new_order_bg_color_reset',
    [
        'label' 	=> esc_html__( 'Table Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-reset-password .cd-email-center' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->end_controls_section();
$widget->start_controls_section(
    'new_order_heading_reset',
    [
        'label'      => __( 'Table Heading', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'customer-reset-password',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'table_heading_typography_reset',
        'selector'  => '{{WRAPPER}} #cd-customer-reset-password .codesigner-email-header h3',
    ]
);
$widget->add_control(
    'new_order_heading_color_reset',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-reset-password .codesigner-email-header h3' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'new_order_heading_bg_color_reset',
    [
        'label' 	=> esc_html__( 'Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-reset-password .codesigner-email-header' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'new_order_message_reset',
    [
        'label'      => __( 'Table Order Message', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'customer-reset-password',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'table_order_message_typography_reset',
        'selector'  => '{{WRAPPER}} #cd-customer-reset-password .codesigner-reset-password-message p,
                        {{WRAPPER}} #cd-customer-reset-password .codesigner-reset-password-message p a',
    ]
);
$widget->add_control(
    'table_order_message_text_color_reset',
    [
        'label' 	=> esc_html__( 'Text Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-reset-password .codesigner-reset-password-message p' => 'color: {{VALUE}}',
            '{{WRAPPER}} #cd-customer-reset-password .codesigner-reset-password-message p a' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'table_order_message_border_color_reset',
    [
        'label' 	=> esc_html__( 'Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-reset-password .codesigner-reset-password-message' => 'border-color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'user_section_reset',
    [
        'label'      => __( 'User Section', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'customer-reset-password',
        ],
    ]
); 
$widget->start_controls_tabs(
    'user_section_tabs_reset'
);
$widget->start_controls_tab(
    'user_section_user_head',
    [
        'label' => esc_html__( 'User', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'user_section_user_head_typography',
        'selector'  => '{{WRAPPER}} #cd-customer-reset-password .co-desginer-user-name-email .cd-usernmae',
    ]
);
$widget->add_control(
    'user_section_user_head_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-reset-password .co-desginer-user-name-email .cd-usernmae' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_tab();

$widget->start_controls_tab(
    'user_section_message_head',
    [
        'label' => esc_html__( 'Message', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'user_section_user_head_msg_typography',
        'selector'  => '{{WRAPPER}} #cd-customer-reset-password .co-desginer-user-name-email .cd-ignore-message',
    ]
);
$widget->add_control(
    'user_section_user_head_msg_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-reset-password .co-desginer-user-name-email .cd-ignore-message' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_tab();

$widget->start_controls_tab(
    'user_section_link_head',
    [
        'label' => esc_html__( 'Link', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'user_section_user_head_link_typography',
        'selector'  => '{{WRAPPER}} #cd-customer-reset-password .cd-reset-password a',
    ]
);
$widget->add_control(
    'user_section_user_head_link_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-reset-password .cd-reset-password a' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_tab();

$widget->end_controls_tabs();
$widget->end_controls_section();


$widget->start_controls_section(
    'before_footer_msg_reset',
    [
        'label'      => __( 'Footer Message', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'customer-reset-password',
        ],
    ]
); 
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'before_footer_msg_typography_reset',
        'selector'  => '{{WRAPPER}} #cd-customer-reset-password .cd-before-footer-message p ,
                        {{WRAPPER}} #cd-customer-reset-password .cd-before-footer-message p a',
    ]
);
$widget->add_control(
    'before_footer_msg_color_reset',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-customer-reset-password .cd-before-footer-message p' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();